#ifndef KEY_MNG_DEFS_H
#define KEY_MNG_DEFS_H

#include "DX_VOS_BaseTypes.h"

/************************* User Key Internal Structure *****************************
 ***********************************************************************************
 * key info | key index | hash pass (sha 256) | key data |       pad     |  WRAP   *
 *---------------------------------------------------------------------------------*
 *	3 words  |	1 word   |	     8 words	   | x words  |up to 7 bytes | 2 words *
 ***********************************************************************************/

/* Offset defines inside the EncKey buffer */
#define KMNG_LLF_ENC_KEY_START_OFFSET_BYTES				0
/* start in offset 0 */
#define KMNG_LLF_ENC_KEY_INFO_OFFSET_BYTES				 KMNG_LLF_ENC_KEY_START_OFFSET_BYTES
/* start in offset 12 */
#define KMNG_LLF_ENC_KEY_INDEX_OFFSET_BYTES				(KMNG_LLF_ENC_KEY_START_OFFSET_BYTES +\
														 KMNG_CONFIG_INFO_SIZE_IN_BYTES)
/* start in offset 16 */
#define KMNG_LLF_ENC_KEY_HASH_OFFSET_BYTES				(KMNG_LLF_ENC_KEY_START_OFFSET_BYTES +\
													     KMNG_CONFIG_INFO_SIZE_IN_BYTES +\
														 KMNG_KEY_INDEX_SIZE_IN_BYTES)
/* start in offset 48 */
#define KMNG_LLF_ENC_KEY_KEY_OFFSET_BYTES				(KMNG_LLF_ENC_KEY_START_OFFSET_BYTES +\
														KMNG_CONFIG_INFO_SIZE_IN_BYTES +\
														KMNG_KEY_INDEX_SIZE_IN_BYTES +\
														KMNG_HASH_PSW_SIZE_IN_BYTES)


#define KMNG_LLF_DH_KEY_MODULUS_SIZE_OFFSET_IN_WORDS			0
#define KMNG_LLF_DH_KEY_MODULUS_OFFSET_IN_WORDS					(KMNG_LLF_DH_KEY_MODULUS_SIZE_OFFSET_IN_WORDS + 1)
#define KMNG_LLF_DH_KEY_GEN_SIZE_OFFSET_IN_WORDS				(KMNG_LLF_DH_KEY_MODULUS_OFFSET_IN_WORDS + 64)
#define KMNG_LLF_DH_KEY_GEN_OFFSET_IN_WORDS						(KMNG_LLF_DH_KEY_GEN_SIZE_OFFSET_IN_WORDS + 1)
#define KMNG_LLF_DH_KEY_Q_SIZE_OFFSET_IN_WORDS					(KMNG_LLF_DH_KEY_GEN_OFFSET_IN_WORDS + 64)
#define KMNG_LLF_DH_KEY_Q_OFFSET_IN_WORDS						(KMNG_LLF_DH_KEY_Q_SIZE_OFFSET_IN_WORDS + 1)
#define KMNG_LLF_DH_KEY_SEED_SIZE_OFFSET_IN_WORDS				(KMNG_LLF_DH_KEY_Q_OFFSET_IN_WORDS + 64)
#define KMNG_LLF_DH_KEY_SEED_OFFSET_IN_WORDS					(KMNG_LLF_DH_KEY_SEED_SIZE_OFFSET_IN_WORDS + 1)
#define KMNG_LLF_DH_KEY_PRIV_SIZE_OFFSET_IN_WORDS				(KMNG_LLF_DH_KEY_SEED_OFFSET_IN_WORDS + 5)
#define KMNG_LLF_DH_KEY_PRIV_OFFSET_IN_WORDS					(KMNG_LLF_DH_KEY_PRIV_SIZE_OFFSET_IN_WORDS + 1)
#define KMNG_LLF_DH_KEY_PUB_SIZE_OFFSET_IN_WORDS				(KMNG_LLF_DH_KEY_PRIV_OFFSET_IN_WORDS + 64)
#define KMNG_LLF_DH_KEY_PUB_OFFSET_IN_WORDS						(KMNG_LLF_DH_KEY_PUB_SIZE_OFFSET_IN_WORDS + 1)


/* For internal use - define the offset with words */
#define KMNG_LLF_ENC_KEY_INFO_OFFSET_WORDS				(KMNG_LLF_ENC_KEY_START_OFFSET_BYTES >> 2)
#define KMNG_LLF_ENC_KEY_INDEX_OFFSET_WORDS				(KMNG_LLF_ENC_KEY_INDEX_OFFSET_BYTES >> 2)
#define KMNG_LLF_ENC_KEY_HASH_OFFSET_WORDS				(KMNG_LLF_ENC_KEY_HASH_OFFSET_BYTES >> 2)
#define KMNG_LLF_ENC_KEY_KEY_OFFSET_WORDS				(KMNG_LLF_ENC_KEY_KEY_OFFSET_BYTES >> 2)

/* Fix sizes */
#define KMNG_LLF_RSA_ASYM_KEY_1024_BITS					1024
#define KMNG_LLF_RSA_ASYM_KEY_2048_BITS					2048
#define KMNG_LLF_HASH256_MD_SIZE_IN_BYTES				32
#define KMNG_LLF_STANDARD_PUBLIC_EXPONENT_VAL			0x010001
#define KMNG_LLF_STANDARD_PUBLIC_EXPONENT_LEN			(DxUint16_t)3

/* paramaters for DH domain generation */
#define KMNG_LLF_DH_DOMAIN_MODULUS_1024_SIZE			1024
#define KMNG_LLF_DH_DOMAIN_MODULUS_2048_SIZE			2048
#define KMNG_LLF_DH_DOMAIN_Q_SIZE						160
#define KMNG_LLF_DH_DOMAIN_SEED_SIZE					20
#define KMNG_LLF_DH_KEY_1024_L_VAL						11
#define KMNG_LLF_DH_KEY_2048_L_VAL						12




#endif /* KEY_MNG_DEFS_H*/
